#### https://time.is/UTC ###

import busio
import adafruit_pcf8523
import time
import rtc    # import the microcontroller system real time clock functionality
import board

myI2C = busio.I2C(board.SCL, board.SDA)
pcf_rtc = adafruit_pcf8523.PCF8523(myI2C)   # create the real time clock hardware object from the PCF8523 clock module
rtc.set_time_source(pcf_rtc)    # set the time source for the microcontroller real time clock functionality to the real time clock hardware object


days = ("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday")
# wday =    0         1         2           3            4          5          6
if False: #True:    # if False, do not change the time setting on the real time clock module.
                    # if True, write the new time setting from below onto the real time clock module.

    #                   (( year, mon, date, hour, min, sec, wday, yday, isdst ))
    t = time.struct_time(( 2022,  12,   19,   18,  07,  35,   6,   -1,    -1 ))
    # you must set year, mon, date, hour, min, sec and weekday
    # yday = day of the year is not supported by this clock,
    # isdst = 'is daylight savings time' can be set but we don't do anything with it at this time

    print("Setting time to:", t)     # uncomment for debugging
    pcf_rtc.datetime = t
    print()

while True:
    timenow = pcf_rtc.datetime
    #print(timenow)  # hardware clock time
    feather_local_time = time.localtime()
    #print(feather_local_time)       # microcontroller local time
    print()
    print( "The date is %s %d-%d-%d" % ( days[ timenow.tm_wday ], timenow.tm_year, timenow.tm_mon, timenow.tm_mday ))
    print( "The time is %d:%02d:%02d" % ( timenow.tm_hour, timenow.tm_min,timenow.tm_sec ))

    if False:
        print()
        battery_low = pcf_rtc.battery_low
        if battery_low:
            print( "Clock battery is low. Replace the clock battery." )
        else:
            print( "Clock battery voltage is OK." )
        print( "the day of the month is %d" % ( timenow.tm_mday ))
        print( "the month is %d" % ( timenow.tm_mon ))

    time.sleep( 1 ) # wait a second
print("program completed")
